<?php
/**
 * Plugin Name: Everest Forms - User Registration
 * Plugin URI: https://wpeverest.com/wordpress-plugins/everest-forms/user-registration/
 * Description: Everest Forms User Registration addon allows you to create a custom WordPress user registration form.
 * Version: 1.0.6
 * Author: WPEverest
 * Author URI: https://wpeverest.com
 * Text Domain: everest-forms-user-registration
 * Domain Path: /languages/
 * EVF requires at least: 1.7.0
 * EVF tested up to: 1.8.2
 *
 * @package EverestForms_User_Registration
 */

defined( 'ABSPATH' ) || exit;

// Define plugin version.
if ( ! defined( 'EVF_USER_REGISTRATION_VERSION' ) ) {
	define( 'EVF_USER_REGISTRATION_VERSION', '1.0.6' );
}

// Define EVF_USER_REGISTRATION_PLUGIN_FILE.
if ( ! defined( 'EVF_USER_REGISTRATION_PLUGIN_FILE' ) ) {
	define( 'EVF_USER_REGISTRATION_PLUGIN_FILE', __FILE__ );
}

// Include the main EverestForms_User_Registration class.
if ( ! class_exists( 'EverestForms_User_Registration' ) ) {
	include_once dirname( __FILE__ ) . '/includes/class-everest-forms-user-registration.php';
}

// Initialize the plugin.
add_action( 'plugins_loaded', array( 'EverestForms_User_Registration', 'get_instance' ) );
