<?php
/**
 * Plugin Name: Everest Forms - Save and Continue
 * Plugin URI: https://wpeverest.com/wordpress-plugins/everest-forms/save-and-continue/
 * Description: Everest Forms Save and Continue addon allows you to save incomplete submission and resume later.
 * Version: 1.0.1
 * Author: WPEverest
 * Author URI: https://wpeverest.com
 * Text Domain: everest-forms-save-and-continue
 * Domain Path: /languages/
 * Requires at least: 5.0
 * Requires PHP: 5.6.20
 *
 * EVF requires at least: 1.7.7
 * EVF tested up to: 1.8.2
 *
 * @package EverestForms\Save_And_Continue
 */

defined( 'ABSPATH' ) || exit;

// Define plugin version.
if ( ! defined( 'EVF_SAVE_AND_CONTINUE_VERSION' ) ) {
	define( 'EVF_SAVE_AND_CONTINUE_VERSION', '1.0.1' );
}

// Define plugin root file.
if ( ! defined( 'EVF_SAVE_AND_CONTINUE_PLUGIN_FILE' ) ) {
	define( 'EVF_SAVE_AND_CONTINUE_PLUGIN_FILE', __FILE__ );
}

/**
 * Autoload packages.
 *
 * We want to fail gracefully if `composer install` has not been executed yet, so we are checking for the autoloader.
 * If the autoloader is not present, let's log the failure and display a nice admin notice.
 */
$autoloader = __DIR__ . '/vendor/autoload.php';
if ( is_readable( $autoloader ) ) {
	require $autoloader;
} else {
	if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
		error_log( // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
			sprintf(
				/* translators: 1: composer command. 2: plugin directory */
				esc_html__( 'Your installation of the Everest Forms - Save and Continue plugin is incomplete. Please run %1$s within the %2$s directory.', 'everest-forms-save-and-continue' ),
				'`composer install`',
				'`' . esc_html( str_replace( ABSPATH, '', __DIR__ ) ) . '`'
			)
		);
	}

	/**
	 * Outputs an admin notice if composer install has not been ran.
	 */
	add_action(
		'admin_notices',
		function() {
			?>
			<div class="notice notice-error">
				<p>
					<?php
					printf(
						/* translators: 1: composer command. 2: plugin directory */
						esc_html__( 'Your installation of the Everest Forms - Save and Continue plugin is incomplete. Please run %1$s within the %2$s directory.', 'everest-forms-save-and-continue' ),
						'<code>composer install</code>',
						'<code>' . esc_html( str_replace( ABSPATH, '', __DIR__ ) ) . '</code>'
					);
					?>
				</p>
			</div>
			<?php
		}
	);
	return;
}

// Register the plugin.
register_activation_hook( EVF_SAVE_AND_CONTINUE_PLUGIN_FILE, array( 'EverestForms\\SaveAndContinue\\SaveAndContinue', 'install' ) );

// Initialize the plugin.
add_action( 'plugins_loaded', array( 'EverestForms\\SaveAndContinue\\Plugin', 'instance' ) );
