/**
 * EverestFormsSaveAndContinue JS
 */
(function ($) {
	var EverestFormsSC = {
		init: function () {
			// Verify Expired Form Data.
			var items = Object.keys(localStorage),
				i = items.length;
			while (i--) {
				if (items[i].match(/^evf-form-/g)) {
					let formData = JSON.parse(localStorage.getItem(items[i]));
					if (
						formData.timestamp == undefined ||
						formData.timestamp < new Date().getTime()
					) {
						localStorage.removeItem(items[i]);
					}
				}
			}

			var excludes = [
				"phone",
				"password",
				"image-upload",
				"file-upload",
				"signature-canvas",
				"credit-card",
				"range-slider",
			];

			var form = $("form.everest-form");

			form.each(function (i, v) {
				$(document).ready(function () {
					// Forms.
					var formTuple = $(v),
						btn = formTuple.find(".evf-save-and-continue"),
						formInputOld = {};

					if (formTuple.hasClass("everest-form-sc-offline-form")) {
						var formInputOld = JSON.parse(
							localStorage.getItem(formTuple.attr("id"))
						);

						// Setting form data.
						if (
							typeof formInputOld != undefined &&
							formInputOld != null
						) {
							EverestFormsSC.scModal({
								form: formTuple.attr("id"),
								title: "",
								content:
									everest_forms_save_and_continue_script.restore_message,
								target: "offline-form",
							});
						}

						// Triggr changes in form data.
						formTuple
							.find(
								"div.evf-field input, div.evf-field select, iv.evf-field input, div.evf-field textarea, div.evf-field checkbox, div.evf-field radio, div.evf-field select"
							)
							.on("focusout", function () {
								var fieldType = $(this)
									.closest(".form-row")
									.attr("class")
									.match(/evf-field-(.*?)\s+/);
								if (!excludes.includes(fieldType[1])) {
									var formInputOld = JSON.parse(
										localStorage.getItem(
											formTuple.attr("id")
										)
									);
									if (formInputOld == null) {
										formInputOld = {};
									}
									var type = $(this).attr("type");
									let dataValue = null;
									switch (type) {
										case "textarea":
											dataValue = $(this).html();
											break;
										case "checkbox":
											dataValue = $(this).prop("checked");
											break;
										case "radio":
											dataValue = $(this).prop("checked");
											$(this)
												.parent()
												.siblings()
												.each(function () {
													formInputOld[
														$(this)
															.find("input:first")
															.attr("id")
													] = false;
												});
											break;
										default:
											dataValue = $(this).val();
									}
									formInputOld[$(this).attr("id")] =
										dataValue;
									formInputOld["timestamp"] =
										EverestFormsSC.getTime(new Date(), 2);
									localStorage.setItem(
										formTuple.attr("id"),
										JSON.stringify(formInputOld)
									);
								}
							});
					}

					//Save amd Continue Event
					btn.on("click", function (e) {
						var data = formTuple.serializeArray();
						e.preventDefault();

						$(this).prop("disabled", true);

						// Change the text to user defined property.
						$(this).html(formTuple.data("process-text"));

						// Add action intend for ajax_form_submission endpoint.
						data.push({
							name: "action",
							value: "everest_forms_sc_form_submission",
						});

						data.push({
							name: "security",
							value: everest_forms_sc_form_submission_params.evf_ajax_submission,
						});

						data.push({
							name: "everest_forms[url]",
							value: window.location.href,
						});

						// Fire the ajax request.
						$.ajax({
							url: everest_forms_sc_form_submission_params.ajax_url,
							type: "POST",
							data: data,
						})
							.done(function (xhr, textStatus, errorThrown) {
								if (true == xhr.success) {
									EverestFormsSC.scModal({
										form: formTuple.attr("id"),
										title: xhr.data.title,
										entry_id: xhr.data.entry_id,
										url: xhr.data.url,
										content: xhr.data.message,
										target: "sc-form",
									});
								} else {
								}
							})
							.fail(function () {})
							.always(function (xhr) {
								$(this).prop("disabled", false);
							});
					});
				});
			});

			var modal =
				'<div class="evf-sc-wrapper"><div class="evf_sc_popup_box">';
			modal += '<h2 class="sc-modal-title"></h2>';
			modal += '<p class="sc-modal-content"></p>';
			modal += '<div class="close"></div>';
			modal +=
				'<div class="group"><button class="btn btn-confirm evf-sc-btn-confirm" type="button">OK</button><button class="btn btn-close evf-sc-btn-close" type="button">CANCEL</button></div></div>';
			modal += "</div>";
			$("body").append(modal);

			$(window).resize();

			$(document).on("click", ".evf-sc-btn-close", function () {
				var form_id = $(this).prev('button').attr('data-form-id').replace("evf-form-", '');
				$(document).find('button#evf-save-and-continue-' + form_id).prop('disabled', false);
				$(document).find(".evf-sc-wrapper").removeClass("z-index-1");

				$(".evf_sc_popup_box")
					.addClass("boom-out")
					.removeClass("boom-in")
					.fadeTo(100, 0);

				$(".overlay").fadeOut(500, function () {
					$(this).remove();
				});
			});

			$(document).on(
				"click",
				".evf-sc-btn-confirm[target='offline-form']",
				function () {
					var formId = $(this).attr("data-form-id");
					var formTuple = $("#" + formId);
					var formInputOld = JSON.parse(
						localStorage.getItem(formTuple.attr("id"))
					);

					formTuple
						.find(
							"div.evf-field input, div.evf-field select, iv.evf-field input, div.evf-field textarea, div.evf-field checkbox, div.evf-field radio"
						)
						.each(function () {
							var dataValue = formInputOld[$(this).attr("id")];
							if (dataValue != undefined && dataValue != "") {
								var type = $(this).attr("type");
								switch (type) {
									case "textarea":
										$(this).html(dataValue);
										break;
									case "checkbox":
										if (true == dataValue) {
											$(this).prop("checked", true);
										}
										break;
									case "radio":
										if (true == dataValue) {
											$(this).prop("checked", true);
										}
										break;
									default:
										$(this).val(dataValue);
								}
							}
						});

					$(".evf_sc_popup_box")
						.addClass("boom-out")
						.removeClass("boom-in")
						.fadeTo(100, 0);

					$(document)
						.find(".evf-sc-wrapper")
						.removeClass("z-index-1");

					$(".overlay").fadeOut(500, function () {
						$(this).remove();
					});
				}
			);

			$(document).on(
				"click",
				".evf-sc-btn-confirm[target='sc-form']",
				function () {
					$submit = $(this);
					$submit.prop("disabled", true);

					var formId = $(this).attr("data-form-id");

					var formTuple = $("#" + formId);

					var $content = $(this)
						.parent()
						.siblings(".sc-modal-content");
					$content.find("div.everest-form-sc-error").remove();
					var email = $content.find("input#email-input").val();
					var nonce = $content.find("input#email-input-nonce").val();
					var entry_id = $(this).attr("entry_id");
					var sc_url = $(this).attr("url");
					if (
						email == undefined ||
						nonce == undefined ||
						email == ""
					) {
						// Attach Email Error Message.
						$(
							'<div class="everest-form-sc-error">Email is Required</div>'
						).insertAfter($content.find("input#email-input"));

						var email = $content
							.find("input#email-input")
							.addClass("error")
							.val();
						$submit.prop("disabled", false);
						return false;
					} else {
						// Check Email
						var regex =
							/^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
						if (regex.test(email) == false) {
							// Attach Email Error Message.
							$(
								'<div class="everest-form-sc-error">Email is Invalid.</div>'
							).insertAfter($content.find("input#email-input"));
							$content
								.find("input#email-input")
								.addClass("error")
								.val("");
							$submit.prop("disabled", false);
							return false;
						}
					}
					// Fire AJAX
					var data = {
						action: "everest_forms_sc_email_send",
						security:
							everest_forms_save_and_continue_script.ajax_nonce,
						nonce: nonce,
						email: email,
						url: sc_url,
						entry_id: entry_id,
					};
					$.ajax({
						url: everest_forms_save_and_continue_script.ajax_url,
						data: data,
						type: "POST",
					}).done(function (xhr, textStatus, errorThrown) {
						if (true == xhr.success) {
							$content
								.siblings("h2.sc-modal-title")
								.html(xhr.data.title);
							$content
								.siblings(".group")
								.find(".evf-sc-btn-confirm")
								.attr("target", "sc-email");
							$content.html(xhr.data.message);
							$content
								.siblings(".group")
								.find(".evf-sc-btn-confirm")
								.hide();
							$content
								.siblings(".group")
								.find(".evf-sc-btn-close")
								.html("OK");
								localStorage.removeItem(formId);
							} else {
							$(
								'<div class="everest-form-sc-error">' +
									xhr.data.message +
									"</div>"
							).insertAfter($content.find("input#email-input"));
							$content
								.find("input#email-input")
								.addClass("error");
						}
						$submit.prop("disabled", false);
					});
				}
			);

			$(document).on("click", ".sc-short-code-url", function (e) {
				e.preventDefault();
				EverestFormsSC.copyUrl($(this));
			});
		},

		// Get Added Timesting.
		getTime: function (date, days) {
			var result = new Date(date);
			result.setDate(result.getDate() + days);
			return new Date(result).getTime();
		},

		// Copy Continue URL.
		copyUrl: function (element) {
			var $temp = $("<input id='evf-sc-clipboard'>");
			$("body").append($temp);
			$temp.val($(element).text()).select();
			document.execCommand("copy");
			$temp.remove();
			alert("URL has been copied!");
		},

		// Save and Continue Modal.
		scModal: function (data) {
			var appendthis = "<div class='overlay'></div>";
			$(document)
				.find(".evf_sc_popup_box h2.sc-modal-title")
				.html(data.title);
			$(document)
				.find(".evf_sc_popup_box .evf-sc-btn-confirm")
				.attr("data-form-id", data.form)
				.attr("target", data.target)
				.attr("url", data.url)
				.attr("entry_id", data.entry_id);
			$(document)
				.find(".evf_sc_popup_box p.sc-modal-content")
				.html(data.content);
			$(document).find("body").append(appendthis);
			$(document).find(".overlay").fadeTo(500, 0.7);
			$(document)
				.find(".evf_sc_popup_box")
				.fadeTo(100, 1)
				.removeClass("boom-out")
				.addClass("boom-in");
			$(document).find(".evf-sc-wrapper").addClass("z-index-1");
			if ("offline-form" == data.target) {
				$(".evf_sc_popup_box").find("h2.sc-modal-title").hide();
			} else {
				$(".evf_sc_popup_box").find("h2.sc-modal-title").show();
			}
		},
	};

	// Initialize.
	EverestFormsSC.init(jQuery);

	// End of popup modal.
})(jQuery);
