<?php
/**
 * EverestForms Form Restriction Logged in user.
 *
 * @package EverestForms_Form_Restriction\LoggedIn_User
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFFR_LoggedIn_User', false ) ) {
	return new EVFFR_LoggedIn_User();
}

/**
 * EVFFR_LoggedIn_User Class.
 */
class EVFFR_LoggedIn_User {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Locker hooks.
	 *
	 * @since 1.0.0
	 */
	public function hooks() {

		add_filter( 'everest_forms_frontend_load', array( $this, 'display_form' ), 10, 2 );
		add_filter( 'everest_forms_process_initial_errors', array( $this, 'submit_form' ), 10, 2 );
	}

	/**
	 * Form Display Actions.
	 *
	 * @param bool  $load_form Form should be loaded or not.
	 * @param array $form_data Form Data.
	 */
	public function display_form( $load_form, $form_data ) {
		if ( empty( $form_data['settings']['form_restriction']['logged_in_form'] ) ) {
			return $load_form;
		}

		if ( is_user_logged_in() ) {
			return $load_form;
		}
		add_action( 'everest_forms_frontend_not_loaded', array( $this, 'show_require_login_message' ), 10, 1 );
	}

	/**
	 * Form submit actions.
	 *
	 * @param array $errors Form submit errors.
	 * @param array $form_data Form Data.
	 */
	public function submit_form( $errors, $form_data ) {
		$locked = true;
		if ( empty( $form_data['settings']['form_restriction']['logged_in_form'] ) ) {
			$locked = false;
		}

		if ( is_user_logged_in() ) {
			$locked = false;
		}

		if ( $locked ) {
			$form_id                      = ! empty( $form_data['id'] ) ? $form_data['id'] : 0;
			$errors[ $form_id ]['header'] = __( 'Form has not been submitted, Please login to submit the form.', 'everest-forms-form-restriction' );
		}
		return $errors;
	}

	/**
	 * Show form expired message.
	 *
	 * @param array $form_data Form Data.
	 */
	public function show_require_login_message( $form_data ) {
		$message = ! empty( $form_data['settings']['form_restriction']['required_login_message'] ) ? $form_data['settings']['form_restriction']['required_login_message'] : '';
		if ( $message ) {
			printf( '<p class="everest-forms-notice everest-forms-notice--error">%s</p>', wp_kses_post( $message ) );
		}
	}
}
