<div class="everest-forms everest-form-user-registration-login-wrapper">
	<?php
	/**
	 * Everest Forms User Login template.
	 *
	 * @package EverestForms_User_Registration
	 * @since   1.0.0
	 */

	if ( function_exists( 'evf_print_notices' ) ) {
		evf_print_notices();
	}
	?>
	<form class="" id="everest-form-user-registation-login" method="POST">
		<div class="evf-field evf-field-username form-row">
			<label><?php echo esc_html__( 'Username or Email', 'everest-forms-user-registration' ); ?></label>
			<input type="text" name="user_login" class="input-text" value="<?php echo isset( $_POST['user_login'] ) ? esc_attr( wp_unslash( $_POST['user_login'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized ?>" required />
		</div>
		<div class="evf-field evf-field-password form-row">
			<label><?php echo esc_html__( 'Password', 'everest-forms-user-registration' ); ?></label>
			<input type="password" name="user_password" class="input-text" required />
		</div>
		<div class="evf-field form-row">
			<label>
			<input type="checkbox" name="rememberme" value='1' <?php checked( '1', ( isset( $_POST['rememberme'] ) ? esc_attr( wp_unslash( $_POST['rememberme'] ) ) : '0' ) ); /* phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.NonceVerification.Missing */ ?> />
			Remember me
			</label>
		</div>
		<?php
		if ( ! empty( $recaptcha_node ) ) {
			echo '<div id="evf-recaptcha-node" style="width:100px;max-width: 100px;"> ' . $recaptcha_node . '</div>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
		?>
		<input type="hidden" name="evf-nonce" value="<?php echo esc_attr( $nonce ); ?>" />
		<input type="hidden" name="evf-redirect-url" value="<?php echo esc_url( $redirect_url ); ?>" />
		<input type="hidden" name="evf-login-recaptcha" value="<?php echo esc_attr( $recaptcha_status ); ?>" />
		<button type="submit" class="button" name="evf-user-login" value="evf-submit"><?php echo esc_html__( 'Login', 'everest-forms-user-registration' ); ?></button>
	</form>
</div>
