/**
 * EverestFormsSaveAndContinue JS
 */
(function ($) {
	var EverestFormsSC = {
		init: function () {
			EverestFormsSC.bindUIActions();
			$(document).ready(EverestFormsSC.ready);
		},

		/**
		 * Document Ready
		 */
		ready: function () {
			$(document)
				.find(
					'.everest-forms-active-email-connections-list li[data-connection-id="connection_save_and_continue"] span.email-remove'
				)
				.addClass("email-sc-remove")
				.removeClass("email-remove");
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] .everest-forms-email-name input'
				)
				.prop("readonly", true);
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] #everest-forms-panel-field-email-connection_save_and_continue-evf_to_email-wrap'
				)
				.remove();
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_to_email]"]'
				)
				.remove();
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_to_email]"]'
				)
				.next()
				.remove();
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_to_email]"]'
				)
				.css("width", "100%");
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] #everest-forms-panel-field-settingsemailconnection_save_and_continue-attach_pdf_to_admin_email-wrap'
				)
				.remove();
			if (
				$(document)
					.find(
						".evf-content-save-and-continue-settings .evf-toggle-switch input"
					)
					.prop("checked") == false
			) {
				$(document)
					.find(
						'.everest-forms-active-email-connections-list li[data-connection-id="connection_save_and_continue"]'
					)
					.css("display", "none");
			}
		},

		/**
		 * Element bindings
		 */
		bindUIActions: function () {
			// Save and Continue Toggler
			$(document).on(
				"change",
				".evf-content-save-and-continue-settings .evf-toggle-switch input",
				function (e) {
					EverestFormsSC.toggleContent(e, this);
				}
			);

			// Trying to remove Save and Continu Connection.
			$(document).on("click", ".email-sc-remove", function (e) {
				EverestFormsSC.removeSaveAndContinueAccount(this, e);
			});
		},

		/**
		 * Remove Save and Continue Email Connection.
		 */
		removeSaveAndContinueAccount: function (el, e) {
			e.preventDefault;
			$.alert({
				title: false,
				content: everest_forms_save_and_continue_params.sc_disabled,
				icon: "dashicons dashicons-info",
				type: "blue",
				buttons: {
					ok: {
						text: evf_data.i18n_ok,
						btnClass: "btn-confirm",
						keys: ["enter"],
					},
				},
			});
		},

		/**
		 * Toggle Save and Continue.
		 */
		toggleContent: function (e, el) {
			var $this = $(el),
				value = $this.prop("checked");
			if (value === false) {
				$this
					.closest(".evf-content-post-submissions-settings")
					.find(".post-submissions-disable-message")
					.remove();
				$this
					.closest(".evf-content-section-title")
					.siblings(".evf-content-section-body")
					.addClass("everest-forms-hidden");
				$(
					'<p class="save-and-continue-disable-message everest-forms-notice everest-forms-notice-info">' +
						everest_forms_save_and_continue_params.sc_disable_message +
						"</p>"
				).insertAfter($this.closest(".evf-content-section-title"));
				EverestFormsSC.removeEmail();
			} else if (value === true) {
				$this
					.closest(".evf-content-section-title")
					.siblings(".evf-content-section-body")
					.removeClass("everest-forms-hidden");
				$this
					.closest(".evf-content-save-and-continue-settings")
					.find(".save-and-continue-disable-message")
					.remove();
				EverestFormsSC.addEmail();
			}
		},

		/**
		 * Add new Email
		 */
		addEmail: function () {
			if (
				$(document).find(
					'.everest-forms-active-email-connections-list li[data-connection-id="connection_save_and_continue"]'
				).length > 0
			) {
				$(document)
					.find(
						'.everest-forms-active-email-connections-list li[data-connection-id="connection_save_and_continue"]'
					)
					.css("display", "flex");
				return;
			}
			var response = {
				success: true,
				data: { connection_id: "connection_save_and_continue" },
			};
			$(document)
				.find(".everest-forms-email-add")
				.trigger("createEmailConnection", {
					response: response,
					name: "Save and Continue",
				});

			// Adding SC remove Class.
			$(document)
				.find(
					'.everest-forms-active-email-connections-list li[data-connection-id="connection_save_and_continue"] span.email-remove'
				)
				.addClass("email-sc-remove")
				.removeClass("email-remove");

			// Adding Subject and Message.
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_email_subject]"]'
				)
				.val( everest_forms_save_and_continue_params.sc_email_subject);
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] textarea[name="settings[email][connection_save_and_continue][evf_email_message]"]'
				)
				.val(
					everest_forms_save_and_continue_params.sc_email_message
				);

			// Removing Unnecessary settings.
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_to_email]"]'
				)
				.remove();
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] #everest-forms-panel-field-email-connection_1-evf_to_email-wrap'
				)
				.remove();
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_to_email]"]'
				)
				.prop("readonly", true);
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_to_email]"]'
				)
				.next()
				.remove();
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] input[name="settings[email][connection_save_and_continue][evf_to_email]"]'
				)
				.css("width", "100%");
			$(document)
				.find(
					'.evf-content-email-settings-inner[data-connection_id="connection_save_and_continue"] #everest-forms-panel-field-settingsemailconnection_connection_save_and_continue-attach_pdf_to_admin_email-wrap'
				)
				.remove();
		},

		/**
		 * Remove Email
		 */
		removeEmail: function () {
			$(document)
				.find(
					'.everest-forms-active-email-connections-list li[data-connection-id="connection_save_and_continue"]'
				)
				.css("display", "none");
		},
	};
	EverestFormsSC.init(jQuery);
})(jQuery);
