jQuery( function ( $ ) {

	var everest_forms_multi_part = {
		$everest_form: $( 'form.everest-form' ),
		conditional_logic: false,
		init: function() {
			this.$everest_form.on( 'click', '.everest-forms-part-button', this.multipart_nav );

			// Display submit button in single part.
			$.each( $( '.everest-forms' ), function () {
				var $this      = $( this ),
					totalParts = $this.find( '.everest-forms-part' ).length;

				if ( 1 === totalParts ) {
					$this.find( '.evf-submit-container .evf-submit' ).show();
					$this.find( '.evf-submit-container .everest-forms-part-button' ).hide();
				} else if ( 1 < totalParts ) {
					$this.find( '.evf-submit-container .evf-submit' ).prop( 'disabled', true );
					$this.find( '.evf-submit-container .evf-submit' ).on( 'evf-conditional-logic-submit', function( e, data ) {
						everest_forms_multi_part.conditional_logic = data;
						if ( $this.find( '.everest-forms-part.last:visible' ).length ) {
							everest_forms_multi_part.handleSubmitButton( $( this ) );
						}
					} );
				}
			});
		},
		multipart_nav: function ( e ) {
			var $this      = $( this ),
				part       = $this.data( 'part' ),
				action     = $this.data( 'action' ),
				part2      = part,
				next       = part + 1,
				prev       = part - 1,
				$form      = $this.closest( '.everest-forms' ),
				$part      = $form.find( '.everest-forms-part-' + part ),
				$submit    = $form.find( '.evf-submit-container .evf-submit' ),
				$next_btn  = $form.find( '.everest-forms-part-next' ),
				$prev_btn  = $form.find( '.everest-forms-part-prev' ),
				$reCAPTCHA = $form.find( '.evf-recaptcha-container' ),
				$indicator = $form.find( '.everest-forms-multi-part-indicator' ),
				totalParts = $form.find( '.everest-forms-part' ).length,
				validation = true;

			e.preventDefault();

			// Toggling between parts.
			if ( 'next' === action ) {
				// Validate.
				if ( 'undefined' !== typeof $.fn.validate ) {
					$part.find( '.evf-field input:visible, .evf-field select:visible, .evf-field textarea:visible, .evf-field input:enabled' ).each( function() {
						var field = $( this );
						if ( ! field.valid() ) {
							validation = false;
						}
					});

					// Scroll to first/top error on part.
					var $topError = $part.find( '.evf-error:visible' ).first();
					if ( $topError.length ) {
						$( 'html, body' ).stop().animate({
							scrollTop: $topError.offset().top - 75
						}, 500, function() {
							$topError.trigger('focus');
						});
					}
				}

				// Move to next part.
				if ( validation ) {
					part2 = next;
					$part.hide();
					var $nextPart = $form.find( '.everest-forms-part-' + next );
					$nextPart.show();
					$prev_btn.show();
					$next_btn.data( 'part', next );
					$prev_btn.data( 'part', next );

					$next_btn.text( $next_btn.data( 'label-part-' + next ) );
					$prev_btn.text( $prev_btn.data( 'label-part-' + next ) );

					if ( $nextPart.hasClass( 'last' ) ) {
						$reCAPTCHA.show();
						if ( everest_forms_multi_part.conditional_logic ) {
							everest_forms_multi_part.handleSubmitButton( $submit );
						} else {
							$submit.show();
							$submit.prop( 'disabled', false );
						}
						$next_btn.hide();
					}

					everest_forms_multi_part.scroll_top( $form );

					$this.trigger( 'evf-init-part-change', [ part2, $form ] );
				}
			} else if ( 'prev' === action ) {
				var $prevPart = $form.find( '.everest-forms-part-' + prev );

				// Move to prev part.
				part2 = prev;
				$part.hide();
				$prevPart.show();
				$reCAPTCHA.hide();
				$submit.hide();
				$submit.prop( 'disabled', true );

				$next_btn.data( 'part', prev );
				$prev_btn.data( 'part', prev );
				$next_btn.show();

				$next_btn.text( $next_btn.data( 'label-part-' + prev ) );
				$prev_btn.text( $prev_btn.data( 'label-part-' + prev ) );

				if ( $prevPart.hasClass( 'first' ) ) {
					$prev_btn.hide();
				}

				everest_forms_multi_part.scroll_top( $form );
				$this.trigger( 'evf-init-part-change', [ part2, $form ] );
			}


			if ( $indicator ) {
				var theme = $indicator.data( 'indicator' );
				if ( 'circles' === theme || 'arrow_steps' === theme ) {
					$form.find( '.everest-forms-multi-part--steps-list li' ).removeClass( 'active' );
					$form.find( '.everest-forms-multi-part--steps-list li' ).filter( function( index ) {
						return index < part2;
					} ).addClass( 'active' );
				} else if ( 'progress' === theme ) {
					var $pageTitle = $indicator.find( '.everest-forms-multi-part-indicator-title' ),
						totalParts = $form.find( '.everest-forms-part' ).length,
						width      = ( part2 / totalParts ) * 100;

					$indicator.find( '.everest-forms-multi-part-indicator-steps-current' ).text( part2 );
					$indicator.find( '.everest-forms-multi-part-indicator-progress' ).css( 'width', width + '%' );

					if ( $pageTitle.data( 'part-' + part2 + '-title' ) ) {
						$pageTitle.css( 'display','inline' ).text( $pageTitle.data( 'part-' + part2 + '-title' ) );
					} else {
						$pageTitle.css( 'display', 'none' );
					}
				}
			}

			setTimeout(function() {
				$( document.body ).trigger( 'evf-frontend-enhanced-select-init' );
			}, 100 );
		},
		scroll_top: function ( $element, callback ) {
			// Scroll to top.
			var element_top = $element.offset().top,
				page_top = $( 'html, body' ).scrollTop(),
				admin_bar_height = 0;

			// Include admin bar height if exists.
			if ( $( '#wpadminbar' ).length !== 0 ) {
				admin_bar_height = $( '#wpadminbar' ).height();
			}

			if ( page_top > element_top ) {
				$('html, body').stop().animate({
					scrollTop: element_top - admin_bar_height - 30 // Additional height for clear visibility.
				}, 500, callback );
			}
		},
		handleSubmitButton: function ( $submit ) {
			if ( 'show' === everest_forms_multi_part.conditional_logic ) {
				$submit.show();
				$submit.prop( 'disabled', false );
			} else if ( 'disable' === everest_forms_multi_part.conditional_logic ) {
				$submit.show();
				$submit.prop( 'disabled', true );
			} else if ( 'hide' === everest_forms_multi_part.conditional_logic ) {
				$submit.hide();
				$submit.prop( 'disabled', true );
			}
		}
	};

	everest_forms_multi_part.init();
});
