/* global evf_multipart_admin, evf_data, PerfectScrollbar */
(function ( $ ) {

	// Enable Perfect Scrollbar.
	$( document ).on( 'init_perfect_scrollbar', function() {
		var tabs_wrapper = $( 'ul.everest-forms-tabs' );

		if ( tabs_wrapper.length ) {
			window.evf_multipart_ps = new PerfectScrollbar( 'ul.everest-forms-tabs', {
				suppressScrollY : true,
				useBothWheelAxes: true,
				wheelPropagation: true
			});
		}
	});

	// Tabbed Panels.
	$( document.body ).on( 'evf-init-tabbed-panels', function() {
		$( 'ul.everest-forms-tabs' ).show();
		$( 'ul.everest-forms-tabs a' ).on( 'click', function( e ) {
			e.preventDefault();
			var part_id    = $( this ).parent().data( 'part-id' ),
				panel_wrap = $( this ).closest( 'div.panel-wrap' );
			$( 'ul.everest-forms-tabs li', panel_wrap ).removeClass( 'active' );
			$( this ).parent().addClass( 'active' );
			$( 'div.panel', panel_wrap ).hide();
			$( $( this ).attr( 'href' ) ).show();
			$( '.evf-admin-field-container' ).attr( 'data-current-part', part_id );
			$( '.everest-forms-tab-content, .everest-forms-panel-content' ).scrollTop(0);
		});
		$( 'div.panel-wrap' ).each( function() {
			$( this ).find( 'ul.everest-forms-tabs li' ).eq( 0 ).find( 'a' ).trigger( 'click' );
		});
	}).trigger( 'evf-init-tabbed-panels' );

	// Enable Multi-Part.
	$( 'input#everest-forms-panel-field-settings-enable_multi_part' ).on( 'change', function() {
		if ( $( this ).is( ':checked' ) ) {
			$( 'div.panel-wrap' ).each( function() {
				$( this ).find( 'ul.everest-forms-tabs li' ).eq( 0 ).find( 'a' ).trigger( 'click' );
			});

			$( '.everest-forms-multi-part-tabs' ).show();
			$( '#everest-forms-builder' ).addClass( 'multi-part-activated' );

			$( '.evf-admin-field-wrapper > .everest-forms-part' ).each( function( index, element ) {
				var $this = $(element),
					prev_current_part = $( '.evf-admin-field-container' ).attr( 'data-current-part' );

				if( $this.is(':empty')  ) {
					var part_id = $this.attr( 'data-part-id' );

					$( '.evf-admin-field-container' ).attr( 'data-current-part', part_id );
					$( '.evf-add-row span' ).trigger( 'click' );
					$( '.evf-admin-field-container' ).attr( 'data-current-part', prev_current_part );
				}
			} );
		} else {
			$( 'div.panel', 'div.panel-wrap' ).show();
			$( '.everest-forms-multi-part-tabs' ).hide();
			$( '#add-fields' ).addClass( 'active' ).trigger( 'click' );
			$( '#everest-forms-builder' ).removeClass( 'multi-part-activated' );
		}
	}).trigger( 'change' );

	// Switch Multi-Part Options tabs.
	$( document.body ).on( 'evf-init-multipart-options-tab', function() {
		$( 'ul.everest-forms-tabs a' ).on( 'click', function( e ) {
			e.preventDefault();
			var part_id = $( this ).parent().data( 'part-id' );

			$( '#field-options' ).hide();
			$( '.everest-forms-multi-part-options' ).show();
			$( '#multi-part-options' ).show().addClass( 'active' );
			$( '#add-fields, #field-options' ).removeClass( 'active' );
			$( '.everest-forms-add-fields, .everest-forms-field-options' ).hide();
			$( '.evf-admin-field-wrapper .everest-forms-field' ).removeClass( 'active' );
			$( '.everest-forms-multi-part-options' ).find( '.everest-forms-multi-part-option' ).hide();

			if ( typeof part_id !== 'undefined' ) {
				$( '#everest-forms-multi-part-option-' + part_id ).show();
			} else {
				$( '.everest-forms-multi-part-options' ).find( '.no-fields' ).show();
			}
		});
	}).trigger( 'evf-init-multipart-options-tab' );

	$( document.body ).on( 'evf-init-switch-field-options', function() {
		$( '.everest-forms-multi-part-options' ).hide();
		$( '#field-options' ).show().addClass( 'active' );
		$( '#multi-part-options' ).hide().removeClass( 'active' );
	});
	$( document.body ).on( 'click', '.everest-forms-fields-tab a', function() {
		var id = $( this ).attr( 'id' );

		if ( 'multi-part-options' !== id ) {
			$( '#field-options' ).show();
			$( '.everest-forms-multi-part-options' ).hide();
			$( '#multi-part-options' ).hide().removeClass( 'active' );
		}
	});

	// Multi-Part Options - Open/close.
	$( document.body ).on( 'init_multipart_options_toggle', function() {
		$( '.everest-forms-multi-part-option' ).on( 'click', '.everest-forms-multi-part-option-group > a', function( event ) {
			event.preventDefault();
			$( this ).parent( '.everest-forms-multi-part-option-group' ).toggleClass( 'closed' ).toggleClass( 'open' );
		});
		$( '.everest-forms-multi-part-option' ).on( 'click', '.everest-forms-multi-part-option-group a', function( event ) {
			// If the user clicks on some form input inside, the box should not be toggled.
			if ( $( event.target ).filter( ':input, option, .sort' ).length ) {
				return;
			}

			$( this ).next( '.everest-forms-multi-part-option-group-inner' ).stop().slideToggle();
		});
		$( '.everest-forms-multi-part-option-group.closed' ).each( function() {
			$( this ).find( '.everest-forms-multi-part-option-group-inner' ).hide();
		});
	} ).trigger( 'init_multipart_options_toggle' );

	// Real-time updates for "Multi-Part" name option.
	$( document.body ).on( 'input', '.everest-forms-multi-part-option-row-name input', function() {
		var $this   = $( this ),
			value   = $this.val(),
			part_id = $this.parents( '.everest-forms-multi-part-option' ).data( 'part-id' );

		$( 'ul.everest-forms-tabs' ).find( '.part_' + part_id + '_data' ).find( 'span' ).text( value );

		// Update perfect scrollerbar.
		if ( 'undefined' !== typeof window.evf_multipart_ps ) {
			window.evf_multipart_ps.update();
		}
	});

	// Add new part (via ajax).
	$( '.everest-forms-multi-part-tabs' ).on( 'click', 'button.add-new-part', function() {
		var $this       = $( this ),
			total_parts = $this.attr( 'data-total-parts' );

		$this.attr( 'disabled', 'disabled' );
		$( '.everest-forms-panel-content' ).block({
			message: null,
			overlayCSS: {
				background: '#fff',
				opacity: 0.6
			}
		});

		var	data = {
			action : 'everest_forms_add_new_part',
			security : evf_multipart_admin.add_new_part_nonce,
			total_parts : total_parts
		};

		$.post( evf_multipart_admin.ajax_url, data, function( response ) {
			if ( response.success && response.data ) {
				if ( response.data.fragments ) {
					$.each( response.data.fragments, function ( key, value ) {
						$( key ).append( value );
					} );
				}

				if ( response.data.new_part_id ) {
					var row_clone   = $( '.evf-admin-row' ).eq(0).clone(),
						part_clone  = $( 'ul.everest-forms-tabs' ).find( 'li' ).eq(0).clone(),
						next_row_id = $( '.evf-add-row' ).attr( 'data-next-row-id' );

					next_row_id++;

					// Row clone.
					row_clone.attr( 'data-row-id', next_row_id );
					row_clone.find( '.evf-admin-grid' ).html( '' );
					$( '.evf-add-row' ).attr( 'data-next-row-id', next_row_id );
					$( '#part_' + response.data.new_part_id, '.evf-admin-field-wrapper' ).append( row_clone );

					// Part clone.
					part_clone.attr( 'data-part-id', response.data.new_part_id );
					part_clone.removeClass().addClass( 'part_' + response.data.new_part_id + '_data' );
					part_clone.find( '.tips' ).attr( 'data-tip', evf_multipart_admin.i18n_tooltip_msg );
					part_clone.find( 'span' ).text( evf_multipart_admin.i18n_part_title );
					part_clone.find( 'a' ).attr( 'href', '#part_' + response.data.new_part_id );
					$( 'ul.everest-forms-tabs' ).find( 'li' ).last().after( part_clone );
				}

				// Triggers.
				$( document.body ).trigger( 'init_tooltips' );
				$( document.body ).trigger( 'evf-init-tabbed-panels' );
				$( document.body ).trigger( 'evf-init-builder-fields' );
				$( document.body ).trigger( 'evf-init-multipart-options-tab' );
				$( document.body ).trigger( 'init_multipart_options_toggle' );

				$( 'div.panel-wrap' ).each( function() {
					$( this ).find( 'ul.everest-forms-tabs li' ).last().find( 'a' ).trigger( 'click' );
				});

				// Update perfect scrollerbar.
				if ( 'undefined' !== typeof window.evf_multipart_ps ) {
					window.evf_multipart_ps.update();
				}

				total_parts++;
			} else {
				window.alert( response.data.error );
			}
			$this.removeAttr( 'disabled' );
			$this.attr( 'data-total-parts', total_parts );
			$( '.everest-forms-panel-content' ).unblock().scrollTop(0);
		});
	});

	// Allow Multi-Part sorting.
	$( 'ul.everest-forms-tabs' ).sortable({
		items: 'li',
		cursor: 'move',
		axis: 'x',
		handle: '.sort',
		scrollSensitivity: 40,
		forcePlaceholderSize: true,
		helper: 'clone',
		opacity: 0.65,
		placeholder: 'evf-sortable-placeholder',
		start: function( event, ui ) {
			$( this ).data( 'elPos', ui.item.index() );
			ui.item.css( 'background-color', '#f6f6f6' );
		},
		stop: function( event, ui ) {
			ui.item.removeAttr( 'style' );
		},
		update: function( event, ui ) {
			var origPos = $( this ).data( 'elPos' );

			$( '.evf-admin-field-wrapper' ).each( function() {
				var	index_field = $( this ).children( '.everest-forms-part' ).eq( ui.item.index() );

				if ( origPos > ui.item.index() ) {
					$( this ).children( '.everest-forms-part' ).eq( origPos ).insertBefore( index_field );
				} else {
					$( this ).children( '.everest-forms-part' ).eq( origPos ).insertAfter( index_field );
				}
			});

			$( '.everest-forms-multi-part-options' ).each( function() {
				var	index_option = $( this ).children( '.everest-forms-multi-part-option' ).eq( ui.item.index() );

				if ( origPos > ui.item.index() ) {
					$( this ).children( '.everest-forms-multi-part-option' ).eq( origPos ).insertBefore( index_option );
				} else {
					$( this ).children( '.everest-forms-multi-part-option' ).eq( origPos ).insertAfter( index_option );
				}
			});
		}
	});

	// Delete part.
	$( document.body ).on( 'click', '.everest-forms-multi-part-option .everest-forms-part-delete', function( e ) {
		e.preventDefault();

		var $this   = $( this ),
			part_id = $this.parents( '.everest-forms-multi-part-option' ).data( 'part-id' );

		if ( $( '.everest-forms-multi-part-option' ).length < 2 ) {
			$.alert({
				title: evf_multipart_admin.i18n_part_locked,
				content: evf_multipart_admin.i18n_part_locked_msg,
				icon: 'dashicons dashicons-info',
				type: 'blue',
				buttons : {
					confirm : {
						text: evf_data.i18n_close,
						btnClass: 'btn-confirm',
						keys: ['enter']
					}
				}
			});
		} else {
			$.confirm({
				title: false,
				content: evf_multipart_admin.i18n_delete_part_confirm,
				type: 'red',
				closeIcon: false,
				backgroundDismiss: false,
				icon: 'dashicons dashicons-warning',
				buttons: {
					confirm: {
						text: evf_data.i18n_ok,
						btnClass: 'btn-confirm',
						keys: ['enter'],
						action: function () {
							$this.closest( '.everest-forms-multi-part-option' ).remove();
							$( '.evf-admin-field-wrapper' ).find( '#part_' + part_id ).remove();
							$( 'ul.everest-forms-tabs' ).find( '.part_' + part_id + '_data' ).remove();

							$( 'div.panel-wrap' ).each( function() {
								$( this ).find( 'ul.everest-forms-tabs li' ).eq( 0 ).find( 'a' ).trigger( 'click' );
							});

							// Update perfect scrollerbar.
							if ( 'undefined' !== typeof window.evf_multipart_ps ) {
								window.evf_multipart_ps.update();
							}
						}
					},
					cancel: {
						text: evf_data.i18n_cancel
					}
				}
			} );
		}
	});

	// Manipulate the form data for Multi-Part.
	$( 'form#everest-forms-builder-form' ).on( 'everest_forms_process_ajax_data', function( e, element, form_data ) {
		var steps   = [],
			builder = $( '#everest-forms-builder' ),
			wrapper = builder.find( '.evf-admin-field-container' );

		if ( builder.hasClass( 'multi-part-activated' ) ) {
			$.each( wrapper.find( '.everest-forms-part' ), function() {
				var $this   = $( this ),
					part_id = $this.data( 'part-id' );

				var row_index = 1;
				$.each( $this.find( '.evf-admin-row' ), function() {
					var	row_id = $( this ).data( 'row-id' );

					steps.push( { name: 'multi_part[part_' + part_id + '][rows][' + row_index + ']', value: 'row_' + row_id } );
					row_index++;
				});
			} );
			form_data = form_data.concat( steps );
		} else {
			// If multipart is disabled remove parts.
			form_data = form_data.filter( function( value ) {
				return 0 !== value.name.indexOf( 'multi_part' );
			} );
		}

		return form_data;
	});
}( jQuery ) );
