<?php
/**
 * EverestForms Form Restriction Password Form.
 *
 * @package EverestForms_Form_Restriction\Password_Form
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFFR_Password_Form', false ) ) {
	return new EVFFR_Password_Form();
}

/**
 * EVFFR_Password_Form Class.
 */
class EVFFR_Password_Form {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Locker hooks.
	 *
	 * @since 1.0.0
	 */
	public function hooks() {

		add_filter( 'everest_forms_frontend_load', array( $this, 'display_form' ), 10, 2 );
		add_filter( 'everest_forms_process_initial_errors', array( $this, 'submit_form' ), 10, 2 );
	}

	/**
	 * Form Display Actions.
	 *
	 * @param bool  $load_form Form should be loaded or not.
	 * @param array $form_data Form Data.
	 */
	public function display_form( $load_form, $form_data ) {
		if ( empty( $form_data['settings']['form_restriction']['password_form'] ) || empty( $form_data['settings']['form_restriction']['password_form_password'] ) ) {
			return $load_form;
		}

		$password      = ! empty( $form_data['settings']['form_restriction']['password_form_password'] ) ? $form_data['settings']['form_restriction']['password_form_password'] : '';
		$user_password = ! empty( $_POST['everest-forms']['password_form_password'] ) ? $_POST['everest-forms']['password_form_password'] : '';

		if ( $password === $user_password ) {
			return $load_form;
		}

		if ( $user_password ) {
			add_action( 'everest_forms_display_submit_before', array( $this, 'add_password_field' ) );
		}
		add_action( 'everest_forms_frontend_not_loaded', array( $this, 'show_locked_html' ), 10, 1 );
	}

	/**
	 * Password field to process form.
	 */
	public function add_password_field() {

		$password = wp_create_nonce( ! empty( $_POST['everest_forms']['password_form_password'] ) ? $_POST['everest_forms']['password_form_password'] : '' );

		echo '<input type="hidden" name="everest_forms[password_form_password]" value="' . esc_attr( $password ) . '">';
	}

	/**
	 * Form submit actions.
	 *
	 * @param array $errors Form submit errors.
	 * @param array $form_data Form Data.
	 */
	public function submit_form( $errors, $form_data ) {
		$locked = true;
		if ( empty( $form_data['settings']['form_restriction']['max_number_entries'] ) || ! isset( $form_data['settings']['form_restriction']['max_entry_number'] ) || 0 >= $form_data['settings']['form_restriction']['max_entry_number'] ) {
			$locked = false;
		}

		$max_entry_count = ! empty( $form_data['settings']['form_restriction']['max_entry_number'] ) ? (int) $form_data['settings']['form_restriction']['max_entry_number'] : 0;

		$entries_count = count( evf_get_entries_ids( $form_data['id'] ) );

		if ( $entries_count < $max_entry_count ) {
			$locked = false;
		}

		if ( $locked ) {
			$form_id                      = ! empty( $form_data['id'] ) ? $form_data['id'] : 0;
			$errors[ $form_id ]['header'] = __( 'Form has not been submitted, Entries count for this form has been exceed.', 'everest-forms-form-restriction' );
		}
		return $errors;
	}

	/**
	 * Show locked HTML.
	 *
	 * @param array $form_data Form Data.
	 */
	public function show_locked_html( $form_data ) {
		$message = ! empty( $form_data['settings']['form_restriction']['password_form_message'] ) ? $form_data['settings']['form_restriction']['password_form_message'] : '';

		$locked_form_id = 'evf-locked-' . $form_data['id'];
		$action         = esc_url( remove_query_arg( 'everest_forms' ) );
		$user_password  = ! empty( $_POST['everest-forms']['password_form_password'] ) ? $_POST['everest-forms']['password_form_password'] : '';
		?>
		<div class="evf-container default everest-forms-password-form" id="everest-forms-<?php echo esc_attr( $locked_form_id ); ?>">

			<?php if ( $message ) : ?>
				<p class="everest-forms-notice everest-forms-notice--warning form-locked-message"><?php echo wp_kses_post( $message ); ?></p>
			<?php endif; ?>

			<form id="everest-forms-form-<?php echo esc_attr( $locked_form_id ); ?>" class="everest-forms-validate everest-form" data-formid="<?php echo esc_attr( $locked_form_id ); ?>" method="post" enctype="multipart/form-data" action="<?php echo esc_attr( $action ); ?>">

				<?php
				if ( ! empty( $user_password ) ) :
					?>
					<div class="everest-forms-notice everest-forms-notice--error"><?php esc_html_e( 'The password is incorrect.', 'everest-forms-form-restriction' ); ?></div>
				<?php endif; ?>

				<div class="evf-field-container">
				<div class="evf-frontend-row" data-row="row_1">
					<div class="evf-frontend-grid evf-grid-1" data-grid="grid_1">
					<div id="<?php echo esc_attr( $locked_form_id ); ?>-field-password-form-password-container" class="evf-field evf-field-password form-row validate-required" data-required-field-message="This field is required." data-field-id="password-form-password">
						<label class="evf-field-label" for="<?php echo esc_attr( $locked_form_id ); ?>-field-password-form-password">
							<span class="evf-label"><?php esc_html_e( 'Password', 'everest-forms-form-restriction' ); ?></span>
							<abbr class="required" title="Required">*</abbr>
						</label>
						<input type="password" id="<?php echo esc_attr( $locked_form_id ); ?>-field_password_form_password" class="input-text" name="everest-forms[password_form_password]" required>
					</div>
					</div>
				</div>
				</div>

				<input type="hidden" name="everest-forms[form_locker_form_id]" value="<?php echo absint( $form_data['id'] ); ?>">

				<div class="evf-submit-container">
					<button type="submit" name="everest_forms[submit]" class="everest-forms-submit-button button evf-submit" id="<?php echo esc_attr( $locked_form_id ); ?>" value="evf-submit" data-process-text="<?php esc_html_e( 'Processing...', 'everest-forms-form-restriction' ); ?>">
						<?php esc_html_e( 'Submit', 'everest-forms-form-restriction' ); ?>
					</button>
				</div>

			</form>
		</div>
		<?php
	}
}
