<?php
/**
 * EverestForms Form Restriction setup
 *
 * @package EverestForms_Form_Restriction
 * @since   1.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Main EverestForms Form Restriction Class.
 *
 * @class EverestForms_Form_Restriction
 */
final class EverestForms_Form_Restriction {

	/**
	 * Plugin version.
	 *
	 * @var string
	 */
	const VERSION = '1.0.1';

	/**
	 * Instance of this class.
	 *
	 * @var object
	 */
	protected static $instance = null;

	/**
	 * Initialize the plugin.
	 */
	private function __construct() {
		// Load plugin text domain.
		add_action( 'init', array( $this, 'load_plugin_textdomain' ) );

		// Checks with Everest Forms Pro is installed.
		if ( defined( 'EFP_VERSION' ) && version_compare( EFP_VERSION, '1.3.0', '>=' ) ) {
			$this->includes();

			// Hooks.
			add_action( 'everest_forms_init', array( $this, 'plugin_updater' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		} else {
			add_action( 'admin_notices', array( $this, 'everest_forms_pro_missing_notice' ) );
		}
	}

	/**
	 * Return an instance of this class.
	 *
	 * @return object A single instance of this class.
	 */
	public static function get_instance() {
		// If the single instance hasn't been set, set it now.
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Load Localisation files.
	 *
	 * Note: the first-loaded translation file overrides any following ones if the same translation is present.
	 *
	 * Locales found in:
	 *      - WP_LANG_DIR/everest-forms-form-restriction/everest-forms-form-restriction-LOCALE.mo
	 *      - WP_LANG_DIR/plugins/everest-forms-form-restriction-LOCALE.mo
	 */
	public function load_plugin_textdomain() {
		$locale = apply_filters( 'plugin_locale', get_locale(), 'everest-forms-form-restriction' );

		load_textdomain( 'everest-forms-form-restriction', WP_LANG_DIR . '/everest-forms-form-restriction/everest-forms-form-restriction-' . $locale . '.mo' );
		load_plugin_textdomain( 'everest-forms-form-restriction', false, plugin_basename( dirname( EVF_FORM_RESTRICTION_PLUGIN_FILE ) ) . '/languages' );
	}

	/**
	 * Includes.
	 */
	private function includes() {
		include_once dirname( __FILE__ ) . '/admin/class-evffr-form-settings.php';
		include_once dirname( __FILE__ ) . '/restriction/entries.php';
		include_once dirname( __FILE__ ) . '/restriction/scheduling.php';
		include_once dirname( __FILE__ ) . '/restriction/loggedIn-user.php';
		include_once dirname( __FILE__ ) . '/restriction/empty-submission.php';
		include_once dirname( __FILE__ ) . '/restriction/password-form.php';
		include_once dirname( __FILE__ ) . '/restriction/country-restriction.php';
	}

	/**
	 * Plugin Updater.
	 */
	public function plugin_updater() {
		if ( class_exists( 'EVF_Plugin_Updater' ) ) {
			return EVF_Plugin_Updater::updates( EVF_FORM_RESTRICTION_PLUGIN_FILE, 61758, self::VERSION );
		}
	}

	/**
	 * Enqueue scripts.
	 */
	public function admin_scripts() {
		$screen    = get_current_screen();
		$screen_id = $screen ? $screen->id : '';
		$suffix    = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		// Register admin scripts.
		wp_register_script( 'everest-forms-form-restriction-builder', plugins_url( "/assets/js/admin/admin{$suffix}.js", EVF_FORM_RESTRICTION_PLUGIN_FILE ), array( 'jquery', 'jquery-ui-core', 'flatpickr' ), self::VERSION, true );

		// Admin scripts for EVF builder page.
		if ( 'everest-forms_page_evf-builder' === $screen_id ) {
			wp_enqueue_script( 'everest-forms-form-restriction-builder' );
		}
	}

	/**
	 * Everest Forms Pro fallback notice.
	 */
	public function everest_forms_pro_missing_notice() {
		/* translators: %s: everest-forms-pro version */
		echo '<div class="error notice is-dismissible"><p>' . sprintf( esc_html__( 'Everest Forms Form Restriction depends on the last version of %s or later to work!', 'everest-forms-form-restriction' ), '<a href="https://wpeverest.com/wordpress-plugins/everest-forms/" target="_blank">' . esc_html__( 'Everest Forms Pro 1.3.0', 'everest-forms-form-restriction' ) . '</a>' ) . '</p></div>';
	}
}
