<?php
/**
 * EverestForms Form Restriction Form Settings
 *
 * @package EverestForms_Form_Restriction\Admin
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFFR_Form_Settings', false ) ) {
	return new EVFFR_Form_Settings();
}

/**
 * EVFFR_Form_Settings Class.
 */
class EVFFR_Form_Settings {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_filter( 'everest_forms_builder_settings_section', array( $this, 'add_settings_section' ) );
		add_action( 'everest_forms_settings_panel_content', array( $this, 'output_form_restriction_settings' ) );
	}

	/**
	 * Register settings section.
	 *
	 * @param  array $sections Settings section.
	 * @return array
	 */
	public function add_settings_section( $sections ) {
		$new_sections = array(
			'form-restriction' => esc_html__( 'Form Restriction', 'everest-forms-form-restriction' ),
		);

		return array_merge( $sections, $new_sections );
	}

	/**
	 * Output From Restriction settings.
	 *
	 * @param object $object Form settings object.
	 */
	public function output_form_restriction_settings( $object ) {
		$max_numnber_entries         = isset( $object->form_data['settings']['form_restriction']['max_number_entries'] ) ? $object->form_data['settings']['form_restriction']['max_number_entries'] : 0;
		$form_scheduling             = isset( $object->form_data['settings']['form_restriction']['form_scheduling'] ) ? $object->form_data['settings']['form_restriction']['form_scheduling'] : 0;
		$logged_in_form              = isset( $object->form_data['settings']['form_restriction']['logged_in_form'] ) ? $object->form_data['settings']['form_restriction']['logged_in_form'] : 0;
		$password_form               = isset( $object->form_data['settings']['form_restriction']['password_form'] ) ? $object->form_data['settings']['form_restriction']['password_form'] : 0;
		$empty_submission            = isset( $object->form_data['settings']['form_restriction']['empty_submission'] ) ? $object->form_data['settings']['form_restriction']['empty_submission'] : 0;
		$country_restriction         = isset( $object->form_data['settings']['form_restriction']['country_restriction'] ) ? $object->form_data['settings']['form_restriction']['country_restriction'] : 0;
		$max_entry_number            = isset( $object->form_data['settings']['form_restriction']['max_entry_number'] ) ? $object->form_data['settings']['form_restriction']['max_entry_number'] : 0;
		$max_entry_message           = isset( $object->form_data['settings']['form_restriction']['max_entry_message'] ) ? $object->form_data['settings']['form_restriction']['max_entry_message'] : esc_html( 'Maximum number of entries exceeded.', 'everest-forms-form-restriction' );
		$submission_date_start       = isset( $object->form_data['settings']['form_restriction']['submission_date_start'] ) ? $object->form_data['settings']['form_restriction']['submission_date_start'] : '';
		$submission_date_end         = isset( $object->form_data['settings']['form_restriction']['submission_date_end'] ) ? $object->form_data['settings']['form_restriction']['submission_date_end'] : '';
		$form_waiting_message        = isset( $object->form_data['settings']['form_restriction']['form_waiting_message'] ) ? $object->form_data['settings']['form_restriction']['form_waiting_message'] : esc_html( 'Form submission is not started yet.', 'everest-forms-form-restriction' );
		$form_expired_message        = isset( $object->form_data['settings']['form_restriction']['form_expired_message'] ) ? $object->form_data['settings']['form_restriction']['form_expired_message'] : esc_html( 'Form submission is now closed.', 'everest-forms-form-restriction' );
		$required_login_message      = isset( $object->form_data['settings']['form_restriction']['required_login_message'] ) ? $object->form_data['settings']['form_restriction']['required_login_message'] : esc_html( 'You must be logged in to submit the form.', 'everest-forms-form-restriction' );
		$password_form_message       = isset( $object->form_data['settings']['form_restriction']['password_form_message'] ) ? $object->form_data['settings']['form_restriction']['password_form_message'] : esc_html( 'This form is password protected.', 'everest-forms-form-restriction' );
		$password_form_password      = isset( $object->form_data['settings']['form_restriction']['password_form_password'] ) ? $object->form_data['settings']['form_restriction']['password_form_password'] : '';
		$empty_submission_message    = isset( $object->form_data['settings']['form_restriction']['empty_submission_message'] ) ? $object->form_data['settings']['form_restriction']['empty_submission_message'] : esc_html( 'Sorry, you cannot submit an empty form.', 'everest-forms-form-restriction' );
		$country_restriction_message = isset( $object->form_data['settings']['form_restriction']['country_restriction_message'] ) ? $object->form_data['settings']['form_restriction']['country_restriction_message'] : esc_html( 'Sorry, you cannot submit this form on your country.', 'everest-forms-form-restriction' );
		?>
		<div class="evf-content-section evf-content-form-restriction-settings">
			<div class="evf-content-section-title"><?php esc_html_e( 'Form Restriction', 'everest-forms-form-restriction' ); ?></div>
				<div class="everest-forms-panel-field evf-toggle-section-wrapper">
					<h3><?php echo esc_html__( 'Entry Limitation', 'everest-forms-form-restriction' ); ?></h3>
					<div class="evf-toggle-section">
						<span class="everest-forms-toggle-form evf-max-number-entries">
							<input id="max-number-entries" type="checkbox" name="settings[form_restriction][max_number_entries]" value="1" <?php checked( '1', $max_numnber_entries, true ); ?> >
							<span class="slider round"></span>
						</span>
						<label for="max-number-entries" class="evf-toggle-label" ><?php esc_html_e( 'Max number of Entries', 'everest-forms-form-restriction' ); ?><i class="dashicons dashicons-editor-help everest-forms-help-tooltip tooltipstered" title="<?php esc_html_e( 'Limits entries to a specified number.', 'everest-forms-form-restriction' ); ?>"></i></span></label>
					</div>
					<div class="evf-hidden-content <?php echo '1' === $max_numnber_entries ? '' : esc_attr( 'everest-forms-hidden' ); ?>">
						<div class="max-entry-section">
							<div class="everest-forms-panel-field">
								<label for="max-entry-number"><?php echo esc_html__( 'Maximum Entries', 'everest-forms-form-restriction' ); ?></label>
								<div class="max-entry-section-content">
									<div class="evf-handler-counter">
										<span class="evf-handler-counter__button evf-handler-counter__button-minus dashicons dashicons-minus"></span>
										<input type="number" id="max-entry-number" min='0' class="evf-handler-counter__input widefat" name="settings[form_restriction][max_entry_number]" value="<?php echo esc_attr( $max_entry_number ); ?>">
										<span class="evf-handler-counter__button evf-handler-counter__button-plus dashicons dashicons-plus"></span>
									</div>
									<div class="entry-period">
										<?php
											everest_forms_panel_field(
												'select',
												'form_restriction',
												'entry_period',
												$object->form_data,
												'',
												array(
													'default' => 'total_entries',
													'options' => array(
														'total_entries' => esc_html__( 'Total Entries', 'everest-forms-form-restriction' ),
														'day'  => esc_html__( 'Per Day', 'everest-forms-form-restriction' ),
														'week' => esc_html__( 'Per Week', 'everest-forms-form-restriction' ),
														'month' => esc_html__( 'Per Month', 'everest-forms-form-restriction' ),
														'year' => esc_html__( 'Per Year', 'everest-forms-form-restriction' ),
													),
													'parent'  => 'settings',
												)
											);
										?>
									</div>
								</div>
							</div>
							<div class="everest-forms-panel-field max_entry_message">
								<?php
									everest_forms_panel_field(
										'textarea',
										'form_restriction',
										'max_entry_message',
										$object->form_data,
										esc_html__( 'Max Entry Message', 'everest-forms-form-restriction' ),
										array(
											'input_class' => 'short',
											'default'     => $max_entry_message,
											'tooltip'     => sprintf( esc_html__( 'Type an entry restricted message.', 'everest-forms-form-restriction' ) ),
											'parent'      => 'settings',
										)
									);
								?>
							</div>
						</div>
					</div>
				</div>
				<div class="everest-forms-panel-field evf-toggle-section-wrapper">
					<h3><?php echo esc_html__( 'Form Scheduling', 'everest-forms-form-restriction' ); ?></h3>
					<div class="evf-toggle-section">
						<span class="everest-forms-toggle-form evf-form-scheduling">
							<input type="checkbox" id="form-scheduling" name="settings[form_restriction][form_scheduling]" value="1" <?php checked( '1', $form_scheduling, true ); ?> >
							<span class="slider round"></span>
						</span>
						<label for="form-scheduling" class="evf-toggle-label" ><?php esc_html_e( 'Form Scheduling', 'everest-forms-form-restriction' ); ?><i class="dashicons dashicons-editor-help everest-forms-help-tooltip tooltipstered" title="<?php esc_html_e( 'Enabling this will display forms only on specified schedules.', 'everest-forms-form-restriction' ); ?>"></i></span></label>
					</div>
					<?php
						wp_enqueue_style( 'everest-forms-flatpickr-style', 'https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css' );
						wp_enqueue_script( 'everest-forms-flatpickr', 'https://cdn.jsdelivr.net/npm/flatpickr' );
					?>
					<div class="evf-hidden-content <?php echo '1' === $form_scheduling ? '' : esc_attr( 'everest-forms-hidden' ); ?>">
						<div class="submission-date-wrapper">
							<div class="evf-form-row">
								<div class="evf-form-col-6 submission-date-start">
									<?php
										everest_forms_panel_field(
											'text',
											'form_restriction',
											'submission_date_start',
											$object->form_data,
											esc_html__( 'Submission Starts', 'everest-forms-form-restriction' ),
											array(
												'default' => $submission_date_start,
												'class'   => 'everest-forms-submission-date',
												'parent'  => 'settings',
											)
										);
									?>
								</div>
								<div class="evf-form-col-6 submission-date-end">
									<?php
										everest_forms_panel_field(
											'text',
											'form_restriction',
											'submission_date_end',
											$object->form_data,
											esc_html__( 'Submission Ends', 'everest-forms-form-restriction' ),
											array(
												'default' => $submission_date_end,
												'class'   => 'everest-forms-submission-date',
												'parent'  => 'settings',
											)
										);
									?>
								</div>
							</div>
							<div class="submission-waiting-message">
								<?php
									everest_forms_panel_field(
										'textarea',
										'form_restriction',
										'form_waiting_message',
										$object->form_data,
										esc_html__( 'Form Waiting Message', 'everest-forms-form-restriction' ),
										array(
											'input_class' => 'short',
											'default'     => $form_waiting_message,
											'tooltip'     => sprintf( esc_html__( 'Type a message to display before the form is visible.', 'everest-forms-form-restriction' ) ),
											'parent'      => 'settings',
										)
									);
								?>
							</div>
							<div class="submission-expired-message">
								<?php
									everest_forms_panel_field(
										'textarea',
										'form_restriction',
										'form_expired_message',
										$object->form_data,
										esc_html__( 'Form Expired Message', 'everest-forms-form-restriction' ),
										array(
											'input_class' => 'short',
											'default'     => $form_expired_message,
											'tooltip'     => sprintf( esc_html__( 'Type a message after the scheduled time is over.', 'everest-forms-form-restriction' ) ),
											'parent'      => 'settings',
										)
									);
								?>
							</div>
						</div>
					</div>
				</div>
				<div class="everest-forms-panel-field evf-toggle-section-wrapper">
					<h3><?php echo esc_html__( 'User Restriction', 'everest-forms-form-restriction' ); ?></h3>
					<div class="evf-toggle-section">
						<span class="everest-forms-toggle-form evf-logged-in-form">
							<input type="checkbox" id="logged-in-form" name="settings[form_restriction][logged_in_form]" value="1" <?php checked( '1', $logged_in_form, true ); ?> >
							<span class="slider round"></span>
						</span>
						<label for="logged-in-form" class="evf-toggle-label" ><?php esc_html_e( 'Require user to be logged in', 'everest-forms-form-restriction' ); ?><i class="dashicons dashicons-editor-help everest-forms-help-tooltip tooltipstered" title="<?php esc_html_e( 'Enabling this will show the form to logged-in users.', 'everest-forms-form-restriction' ); ?>"></i></span></label>
					</div>
					<div class="evf-hidden-content <?php echo '1' === $logged_in_form ? '' : esc_attr( 'everest-forms-hidden' ); ?>">
						<div class="required-login-message">
							<?php
								everest_forms_panel_field(
									'textarea',
									'form_restriction',
									'required_login_message',
									$object->form_data,
									esc_html__( 'Require Login Message', 'everest-forms-form-restriction' ),
									array(
										'input_class' => 'short',
										'default'     => $required_login_message,
										'tooltip'     => sprintf( esc_html__( 'Type a message to display for non-logged in users.', 'everest-forms-form-restriction' ) ),
										'parent'      => 'settings',
									)
								);
							?>
						</div>
					</div>
				</div>

				<div class="everest-forms-panel-field evf-toggle-section-wrapper">
					<h3><?php echo esc_html__( 'Password Restriction', 'everest-forms-form-restriction' ); ?></h3>
					<div class="evf-toggle-section">
						<span class="everest-forms-toggle-form evf-password-form">
							<input type="checkbox" id="password-form" name="settings[form_restriction][password_form]" value="1" <?php checked( '1', $password_form, true ); ?> >
							<span class="slider round"></span>
						</span>
						<label for="password-form" class="evf-toggle-label" ><?php esc_html_e( 'Password Protection', 'everest-forms-form-restriction' ); ?><i class="dashicons dashicons-editor-help everest-forms-help-tooltip tooltipstered" title="<?php esc_html_e( 'Enabling this option will hide the form with a password.', 'everest-forms-form-restriction' ); ?>"></i></span></label>
					</div>
					<div class="evf-hidden-content <?php echo '1' === $password_form ? '' : esc_attr( 'everest-forms-hidden' ); ?>">
						<div class="required-login-message">
							<?php
								everest_forms_panel_field(
									'text',
									'form_restriction',
									'password_form_password',
									$object->form_data,
									esc_html__( 'Password', 'everest-forms-form-restriction' ),
									array(
										'input_class' => 'short',
										'default'     => $password_form_password,
										'tooltip'     => sprintf( esc_html__( 'Type in the password needed to unlock the form.', 'everest-forms-form-restriction' ) ),
										'parent'      => 'settings',
									)
								);
								everest_forms_panel_field(
									'textarea',
									'form_restriction',
									'password_form_message',
									$object->form_data,
									esc_html__( 'Password Form Message', 'everest-forms-form-restriction' ),
									array(
										'input_class' => 'short',
										'default'     => $password_form_message,
										'tooltip'     => sprintf( esc_html__( 'Type a message to display on the password-restricted form.', 'everest-forms-form-restriction' ) ),
										'parent'      => 'settings',
									)
								);
							?>
						</div>
					</div>
				</div>
				<div class="everest-forms-panel-field evf-toggle-section-wrapper">
					<h3><?php echo esc_html__( 'Form Submission', 'everest-forms-form-restriction' ); ?></h3>
					<div class="evf-toggle-section">
						<span class="everest-forms-toggle-form evf-empty-submission">
							<input type="checkbox" id="empty-submission" name="settings[form_restriction][empty_submission]" value="1" <?php checked( '1', $empty_submission, true ); ?> >
							<span class="slider round"></span>
						</span>
						<label for="empty-submission" class="evf-toggle-label" ><?php esc_html_e( 'Deny empty submission', 'everest-forms-form-restriction' ); ?><i class="dashicons dashicons-editor-help everest-forms-help-tooltip tooltipstered" title="<?php esc_html_e( 'Enable this option to stop the submission of empty forms.', 'everest-forms-form-restriction' ); ?>"></i></span></label>
					</div>
					<div class="evf-hidden-content <?php echo '1' === $empty_submission ? '' : esc_attr( 'everest-forms-hidden' ); ?>">
						<div class="required-login-message">
							<?php
								everest_forms_panel_field(
									'textarea',
									'form_restriction',
									'empty_submission_message',
									$object->form_data,
									esc_html__( 'Empty Submission Message', 'everest-forms-form-restriction' ),
									array(
										'input_class' => 'short',
										'default'     => $empty_submission_message,
										'tooltip'     => sprintf( esc_html__( 'Type a message to show when someone tries to submit an empty form.', 'everest-forms-form-restriction' ) ),
										'parent'      => 'settings',
									)
								);
							?>
						</div>
					</div>
				</div>
				<div class="everest-forms-panel-field evf-toggle-section-wrapper">
					<h3><?php echo esc_html__( 'Form Restriction by country', 'everest-forms-form-restriction' ); ?></h3>
					<div class="evf-toggle-section">
						<span class="everest-forms-toggle-form evf-country-restriction">
							<input type="checkbox" id="country-restriction" name="settings[form_restriction][country_restriction]" value="1" <?php checked( '1', $country_restriction, true ); ?> >
							<span class="slider round"></span>
						</span>
						<label for="country-restriction" class="evf-toggle-label" ><?php esc_html_e( 'Deny form submission by country', 'everest-forms-form-restriction' ); ?><i class="dashicons dashicons-editor-help everest-forms-help-tooltip tooltipstered" title="<?php esc_html_e( 'Enable this option to stop the submission of empty forms.', 'everest-forms-form-restriction' ); ?>"></i></span></label>
					</div>
					<div class="evf-hidden-content <?php echo '1' === $country_restriction ? '' : esc_attr( 'everest-forms-hidden' ); ?>">
						<div class="required-login-message">
							<?php
							$countries = evf_get_countries();
								everest_forms_panel_field(
									'select',
									'form_restriction',
									'restricted_country',
									$object->form_data,
									esc_html__( 'Choose country to restrict', 'everest-forms-form-restriction' ),
									array(
										'input_class' => 'short',
										'default'     => '',
										'tooltip'     => sprintf( esc_html__( 'Choose country which you want to restrict.', 'everest-forms-form-restriction' ) ),
										'parent'      => 'settings',
										'options'     => $countries,
									)
								);
								everest_forms_panel_field(
									'textarea',
									'form_restriction',
									'country_restriction_message',
									$object->form_data,
									esc_html__( 'Country Restriction Message', 'everest-forms-form-restriction' ),
									array(
										'input_class' => 'short',
										'default'     => $country_restriction_message,
										'tooltip'     => sprintf( esc_html__( 'Type a message to show when someone tries to submit form from restricted country.', 'everest-forms-form-restriction' ) ),
										'parent'      => 'settings',
									)
								);
							?>
						</div>
					</div>
				</div>
			</div>
		<?php
	}

}
