<?php
/**
 * Plugin Name: Everest Forms - Custom Captcha
 * Plugin URI: https://wpeverest.com/wordpress-plugins/everest-forms/captcha/
 * Description: Everest Forms Custom Captcha addon allows you to add Custom Questions and Math Captcha to your forms for spam prevention.
 * Version: 1.0.1
 * Author: WPEverest
 * Author URI: https://wpeverest.com
 * License: GPLv3 or later
 * Text Domain: everest-forms-captcha
 * Domain Path: /languages
 * EVF requires at least: 1.4.5
 * EVF tested up to: 1.6.5
 *
 * @package EverestForms_Captcha
 */

defined( 'ABSPATH' ) || exit;

// Define EVF_CAPTCHA_PLUGIN_FILE.
if ( ! defined( 'EVF_CAPTCHA_PLUGIN_FILE' ) ) {
	define( 'EVF_CAPTCHA_PLUGIN_FILE', __FILE__ );
}

// Include the main EverestForms_Captcha class.
if ( ! class_exists( 'EverestForms_Captcha' ) ) {
	include_once dirname( __FILE__ ) . '/includes/class-everest-forms-captcha.php';
}

// Initialize the plugin.
add_action( 'plugins_loaded', array( 'EverestForms_Captcha', 'get_instance' ) );
