/* global evf_data */
(function ( $ ) {

	var EVFCaptcha = {

		/**
		 * Initialize.
		 *
		 * @since 1.0.0
		 */
		init: function() {
			$( document ).ready( EVFCaptcha.ready );
		},

		/**
		 * Document ready.
		 *
		 * @since 1.0.0
		 */
		ready: function() {
			var $builder = $( '#everest-forms-builder' );

			// Format toggle.
			$builder.on( 'change', '.everest-forms-field-option-captcha .everest-forms-field-option-row-format select', function() {
				var $this = $( this ),
					value = $this.val(),
					id    = $this.parent().data( 'field-id' );

				if ( value === 'math' ) {
					$( '#everest-forms-field-option-row-' + id + '-questions' ).hide();
				} else {
					$( '#everest-forms-field-option-row-' + id + '-questions' ).show();
				}
			});

			// Add new captcha question.
			$builder.on( 'click', '.everest-forms-field-option-row-questions .add', function( event ) {
				event.preventDefault();

				var $this      = $( this ),
					$parent    = $this.parent().parent(),
					fieldID    = $this.closest( '.everest-forms-field-option-row-questions' ).data( 'field-id' ),
					id         = $parent.parent().attr( 'data-next-id' ),
					$question  = $parent.clone().insertAfter( $parent );

				$question.attr( 'data-key', id );
				$question.find( 'input.question' ).val( '' ).attr( 'name', 'form_fields[' + fieldID + '][questions][' + id + '][question]' );
				$question.find( 'input.answer' ).val( '' ).attr( 'name', 'form_fields[' + fieldID + '][questions][' + id + '][answer]' );
				id ++;
				$parent.parent().attr( 'data-next-id', id );
			});

			// Remove captcha question.
			$builder.on( 'click', '.everest-forms-field-option-row-questions .remove', function( event ) {
				event.preventDefault();

				var $this = $( this ),
					$list = $this.closest( '.evf-questions-list' ),
					total = $list.find( 'li' ).length;

				if ( total === 1 ) {
					$.alert({
						title:   false,
						content: evf_data.i18n_field_error_choice,
						icon: 'dashicons dashicons-info',
						type: 'blue',
						buttons: {
							confirm: {
								text: evf_data.i18n_ok,
								btnClass: 'btn-confirm',
								keys: [ 'enter' ]
							}
						}
					});
				} else {
					$this.parent().parent().remove();
				}
			});

			// Captch questions sample question.
			$builder.on( 'input', '.everest-forms-field-option-row-questions li:first-of-type .question', function() {
				var $this   = $( this ),
					fieldID = $this.closest( '.evf-questions-list' ).data( 'field-id' );

				$( '#everest-forms-field-'+fieldID ).find( '.everest-forms-question' ).text( $this.val() );
			});
		}
	};

	EVFCaptcha.init();
}( jQuery ) );
