<?php
/**
 * EverestForms Save and Continue Form Settings
 *
 * @package EverestForms_save_and_continue\Admin
 * @version 1.0.0
 */

namespace EverestForms\SaveAndContinue\Admin;

/**
 * Setting Class.
 *
 * @since 1.0.0
 */
class Setting {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		add_filter( 'everest_forms_builder_settings_section', array( $this, 'add_builder_settings_section' ) );
		add_action( 'everest_forms_settings_panel_content', array( $this, 'add_settings_panel_content' ) );
		add_action( 'everest_forms_inline_general_settings', array( $this, 'add_inline_gerenal_settings' ) );
	}

	/**
	 * Register settings section.
	 *
	 * @param  array $sections Settings section.
	 *
	 * @since 1.0.0
	 */
	public function add_builder_settings_section( $sections ) {
		$new_sections = array(
			'save-and-continue' => esc_html__( 'Save and Continue', 'everest-forms-save-and-continue' ),
		);

		return array_merge( $sections, $new_sections );
	}

	/**
	 * Add Save and Continue Setting panel content.
	 *
	 * @param object $object Form settings object.
	 *
	 * @since 1.0.0
	 */
	public function add_settings_panel_content( $object ) {
		$value        = isset( $object->form_data['settings']['enable_save_and_continue'] ) ? $object->form_data['settings']['enable_save_and_continue'] : 0;
		$hidden_class = 0 === $value ? 'everest-forms-hidden' : '';
		?>
		<div class="evf-content-section evf-content-save-and-continue-settings">
			<div class="evf-content-section-title">
				<div class="evf-title"><?php esc_html_e( 'Save and Continue', 'everest-forms-save-and-continue' ); ?></div>
				<div class="evf-toggle-section">
					<label class="evf-toggle-switch">
						<input type="checkbox" name="settings[enable_save_and_continue]" value="1" <?php checked( '1', $value, true ); ?> >
						<span class="evf-toggle-switch-wrap"></span>
						<span class="evf-toggle-switch-control"></span>
					</label>
				</div>
			</div>
			<?php
			if ( 'everest-forms-hidden' === $hidden_class ) {
				echo '<p class="save-and-continue-disable-message everest-forms-notice everest-forms-notice-info">' . esc_html__( 'Save and Continue is currently disabled. Please enable it to activate this feature Everest Forms.', 'everest-forms-save-and-continue' ) . '</p>';
			}
			?>
			<div class = "evf-content-section-body <?php echo esc_attr( $hidden_class ); ?>" >

			<?php
			everest_forms_panel_field(
				'text',
				'settings',
				'save_and_continue_submit',
				$object->form_data,
				esc_html__( 'Submit Button Label', 'everest-forms-save-and-continue' ),
				array(
					'default' => isset( $object->form_data->save_and_continue_submit ) ? $object->form_data->save_and_continue_submit : esc_html__( 'Save and Continue', 'everest-forms-save-and-continue' ),
				)
			);
			everest_forms_panel_field(
				'text',
				'settings',
				'save_and_continue_submit_class',
				$object->form_data,
				esc_html__( 'Submit Button Class', 'everest-forms-save-and-continue' ),
				array(
					'default' => isset( $object->form_data->save_and_continue_submit_class ) ? $object->form_data->save_and_continue_submit_class : '',
					'tooltip' => esc_html__( 'Enter the Class Name for Submit Button', 'everest-forms-save-and-continue' ),
				)
			);

			everest_forms_panel_field(
				'select',
				'settings',
				'save_and_continue_time',
				$object->form_data,
				esc_html__( 'Link Expiration Period', 'everest-forms-save-and-continue' ),
				array(
					'options' => array(
						'week'      => esc_html__( 'In a week', 'everest-forms-save-and-continue' ),
						'two_weeks' => esc_html__( 'In two weeks', 'everest-forms-save-and-continue' ),
						'month'     => esc_html__( 'In a month', 'everest-forms-save-and-continue' ),
					),
					'default' => isset( $object->form_data->save_and_continue_submit_time ) ? $object->form_data->save_and_continue_submit_time : 'week',
					'tooltip' => esc_html__( 'Select expiration time for generated link', 'everest-forms-save-and-continue' ),
				)
			);

			everest_forms_panel_field(
				'text',
				'settings',
				'save_and_continue_confirmation_title',
				$object->form_data,
				esc_html__( 'Confirmation Title', 'everest-forms-save-and-continue' ),
				array(
					'default' => isset( $object->form_data->save_and_continue_confirmation_title ) ? $object->form_data->save_and_continue_confirmation_title : esc_html__( 'Form has been saved !', 'everest-forms-save-and-continue' ),
					'tooltip' => esc_html__( 'Enter the confirmation Title.', 'everest-forms-save-and-continue' ),
				)
			);

			everest_forms_panel_field(
				'tinymce',
				'settings',
				'save_and_continue_confirmation_message',
				$object->form_data,
				esc_html__( 'Confirmation Message', 'everest-forms-save-and-continue' ),
				array(
					'class'     => 'everest-forms-sc-smart-tags',
					'default'   => isset( $object->form_data->save_and_continue_confirmation_message ) ? $object->form_data->save_and_continue_confirmation_message :
					sprintf(
						/* translators: %1$s - Save and Continue Link, %2$s - Save and Continue expiration date, %3$s - Save and Continue Email input. */
						esc_html__( 'Your partial submission has been saved successfully. Please refer %1$s to retrieve your information within %2$s. Receive the link in your email.%3$s', 'everest-forms-save-and-continue' ),
						'{save_and_continue_url}',
						'{save_and_continue_time}',
						'{save_and_continue_email_input}'
					),
					'tooltip'   => esc_html__( 'Enter the confirmation Message.', 'everest-forms-save-and-continue' ),
					'smarttags' => array(
						'type' => 'other',
					),
					/* translators: %1$s - Save and Continue link, %2$s - Save and Continue Email input. */
					'after'     => '<p class="desc">' . sprintf( esc_html__( 'Make sure you have %1$s and %2$s Smart Tags in the confirmation message.', 'everest-forms-save-and-continue' ), '<code>{save_and_continue_url}</code>', '<code>{save_and_continue_email_input}</code>' ) . '</p>',
				)
			);

			?>
			</div>
		</div>
		<?php

	}

	/**
	 * Add Setting to General for Offline Form.
	 *
	 * @param object $object Form settings object.
	 *
	 * @since 1.0.0
	 */
	public function add_inline_gerenal_settings( $object ) {

		everest_forms_panel_field(
			'checkbox',
			'settings',
			'save_and_continue_offline_form',
			$object->form_data,
			sprintf( esc_html__( 'Enable Offline Form', 'everest-forms-save-and-continue' ) ),
			array(
				'default' => ! empty( $object->form_data->save_and_continue_offline_form ) ? $object->form_data->save_and_continue_offline_form : '0',
				'class'   => 'everest-forms-attach-pdf-to-admin-email',
				'tooltip' => esc_html__( 'Offline data will be expired in 48 hours.', 'everest-forms-save-and-continue' ),
			)
		);
	}

}
