<?php
/**
 * EverestForms Multi-Part Form Settings
 *
 * @package EverestForms_MultiPart\Admin
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFMP_Form_Settings', false ) ) {
	return new EVFMP_Form_Settings();
}

/**
 * EVFMP_Form_Settings Class.
 */
class EVFMP_Form_Settings {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_filter( 'everest_forms_builder_settings_section', array( $this, 'add_settings_section' ) );
		add_action( 'everest_forms_settings_panel_content', array( $this, 'output_multipart_settings' ) );
	}

	/**
	 * Register settings section.
	 *
	 * @param  array $sections Settings section.
	 * @return array
	 */
	public function add_settings_section( $sections ) {
		$new_sections = array(
			'multi-part' => esc_html__( 'Multi-Part', 'everest-forms-multi-part' ),
		);

		return array_merge( $sections, $new_sections );
	}

	/**
	 * Output Multi-part settings.
	 *
	 * @param object $object Form settings object.
	 */
	public function output_multipart_settings( $object ) {
		$settings = isset( $object->form_data['settings'] ) ? $object->form_data['settings'] : array();
		?>
		<div class="evf-content-section evf-content-multi-part-settings">
		<div class="evf-content-section-title"><?php esc_html_e( 'Multi-Part Form', 'everest-forms-multi-part' ); ?></div>
			<?php
				everest_forms_panel_field(
					'checkbox',
					'settings',
					'enable_multi_part',
					$object->form_data,
					esc_html__( 'Enable Multi-Part form.', 'everest-forms-multi-part' ),
					array(
						'default' => isset( $settings['enable_multi_part'] ) ? $settings['enable_multi_part'] : 0,
					)
				);

				everest_forms_panel_field(
					'select',
					'settings[multi_part]',
					'indicator',
					$object->form_data,
					esc_html__( 'Progress Indicator', 'everest-forms-multi-part' ),
					array(
						'default' => isset( $settings['multi_part']['indicator'] ) ? $settings['multi_part']['indicator'] : 'progress',
						'tooltip' => esc_html__( 'Select theme for Part Indicator which is displayed at the top of the form.', 'everest-forms-multi-part' ),
						'options' => array(
							'progress'    => esc_html__( 'Progress Bar', 'everest-forms-multi-part' ),
							'circles'     => esc_html__( 'Circle Bar', 'everest-forms-multi-part' ),
							'arrow_steps' => esc_html__( 'Arrow Steps', 'everest-forms-multi-part' ),
							'none'        => esc_html__( 'None', 'everest-forms-multi-part' ),
						),
					)
				);

				everest_forms_panel_field(
					'text',
					'settings[multi_part]',
					'indicator_color',
					$object->form_data,
					__( 'Progress Indicator Color', 'everest-forms-multi-part' ),
					array(
						'default'     => isset( $settings['multi_part']['indicator_color'] ) ? $settings['multi_part']['indicator_color'] : '#51cf66',
						'tooltip'     => esc_html__( 'Select the primary color for the Part Indicator theme.', 'everest-forms-multi-part' ),
						'input_class' => 'evf-colorpicker',
						'data'        => array(
							'default-color' => '#5cb85c',
						),
					)
				);

				everest_forms_panel_field(
					'select',
					'settings[multi_part]',
					'nav_align',
					$object->form_data,
					esc_html__( 'Part Navigation Alignment', 'everest-forms-multi-part' ),
					array(
						'default' => isset( $settings['multi_part']['nav_align'] ) ? $settings['multi_part']['nav_align'] : 'center',
						'tooltip' => esc_html__( 'Select the alignment for the Next/Previous part navigation buttons', 'everest-forms-multi-part' ),
						'options' => array(
							'left'   => esc_html__( 'Left', 'everest-forms-multi-part' ),
							'right'  => esc_html__( 'Right', 'everest-forms-multi-part' ),
							'center' => esc_html__( 'Center', 'everest-forms-multi-part' ),
							'split'  => esc_html__( 'Split', 'everest-forms-multi-part' ),
						),
					)
				);

				do_action( 'everest_forms_inline_multi_part_settings', $object );
			?>
		</div>
		<?php
	}
}

return new EVFMP_Form_Settings();
