<?php
/**
 * EverestForms Form Restriction Form Scheduling.
 *
 * @package EverestForms_Form_Restriction\Form_Scheduling
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFFR_Form_Scheduling', false ) ) {
	return new EVFFR_Form_Scheduling();
}

/**
 * EVFFR_Form_Scheduling Class.
 */
class EVFFR_Form_Scheduling {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Locker hooks.
	 *
	 * @since 1.0.0
	 */
	public function hooks() {

		add_filter( 'everest_forms_frontend_load', array( $this, 'display_form' ), 10, 2 );
		add_filter( 'everest_forms_process_initial_errors', array( $this, 'submit_form' ), 10, 2 );
	}

	/**
	 * Form Display Actions.
	 *
	 * @param bool  $load_form Form should be loaded or not.
	 * @param array $form_data Form Data.
	 */
	public function display_form( $load_form, $form_data ) {
		if ( empty( $form_data['settings']['form_restriction']['form_scheduling'] ) ) {
			return $load_form;
		}

		$submission_start = ! empty( $form_data['settings']['form_restriction']['submission_date_start'] ) ? $form_data['settings']['form_restriction']['submission_date_start'] : '';
		$submission_end   = ! empty( $form_data['settings']['form_restriction']['submission_date_end'] ) ? $form_data['settings']['form_restriction']['submission_date_end'] : '';

		if ( empty( $submission_start ) && empty( $submission_end ) ) {
			return $load_form;
		}

		$current = current_time( 'mysql' );

		if ( ! empty( $submission_start ) && ! empty( $submission_end ) && $submission_start > $current || ! empty( $submission_start ) && empty( $submission_end ) && $submission_start > $current ) {
			add_action( 'everest_forms_frontend_not_loaded', array( $this, 'show_form_waiting_message' ), 10, 1 );
			return false;
		}

		if ( ! empty( $submission_start ) && empty( $submission_end ) && $submission_start < $current ) {
			return $load_form;
		}

		if ( ! empty( $submission_end ) && empty( $submission_start ) && $submission_end > $current ) {
			return $load_form;
		}

		if ( ! empty( $submission_start ) && ! empty( $submission_end ) && $submission_start < $current && $submission_end > $current ) {
			return $load_form;
		}
		add_action( 'everest_forms_frontend_not_loaded', array( $this, 'show_form_expired_message' ), 10, 1 );
	}

	/**
	 * Form submit actions.
	 *
	 * @param array $errors Form submit errors.
	 * @param array $form_data Form Data.
	 */
	public function submit_form( $errors, $form_data ) {
		$locked = true;
		if ( empty( $form_data['settings']['form_restriction']['form_scheduling'] ) ) {
			$locked = false;
		}

		$submission_start = ! empty( $form_data['settings']['form_restriction']['submission_date_start'] ) ? $form_data['settings']['form_restriction']['submission_date_start'] : '';
		$submission_end   = ! empty( $form_data['settings']['form_restriction']['submission_date_end'] ) ? $form_data['settings']['form_restriction']['submission_date_end'] : '';

		if ( empty( $submission_start ) && empty( $submission_end ) ) {
			$locked = false;
		}

		$current = current_time( 'mysql' );

		if ( ! empty( $submission_start ) && empty( $submission_end ) && $submission_start < $current ) {
			$locked = false;
		}

		if ( ! empty( $submission_end ) && empty( $submission_start ) && $submission_end > $current ) {
			$locked = false;
		}

		if ( ! empty( $submission_start ) && ! empty( $submission_end ) && $submission_start < $current && $submission_end > $current ) {
			$locked = false;
		}

		if ( $locked ) {
			$form_id                      = ! empty( $form_data['id'] ) ? $form_data['id'] : 0;
			$errors[ $form_id ]['header'] = __( 'Form has not been submitted, Form submission date has been expired.', 'everest-forms-form-restriction' );
		}
		return $errors;
	}

	/**
	 * Show form expired message.
	 *
	 * @param array $form_data Form Data.
	 */
	public function show_form_expired_message( $form_data ) {
		$message = ! empty( $form_data['settings']['form_restriction']['form_expired_message'] ) ? $form_data['settings']['form_restriction']['form_expired_message'] : '';
		if ( $message ) {
			printf( '<p class="everest-forms-notice everest-forms-notice--error">%s</p>', wp_kses_post( $message ) );
		}
	}

	/**
	 * Show form waiting message.
	 *
	 * @param array $form_data Form Data.
	 */
	public function show_form_waiting_message( $form_data ) {
		$message = ! empty( $form_data['settings']['form_restriction']['form_waiting_message'] ) ? $form_data['settings']['form_restriction']['form_waiting_message'] : '';
		if ( $message ) {
			printf( '<p class="everest-forms-notice everest-forms-notice--error">%s</p>', wp_kses_post( $message ) );
		}
	}
}
