<?php
/**
 * EverestForms Form Restriction Entry Limit.
 *
 * @package EverestForms_Form_Restriction\Entry_Limit
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFFR_Entry_Limit', false ) ) {
	return new EVFFR_Entry_Limit();
}

/**
 * EVFFR_Entry_Limit Class.
 */
class EVFFR_Entry_Limit {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Locker hooks.
	 *
	 * @since 1.0.0
	 */
	public function hooks() {

		add_filter( 'everest_forms_frontend_load', array( $this, 'display_form' ), 10, 2 );
		add_filter( 'everest_forms_process_initial_errors', array( $this, 'submit_form' ), 10, 2 );
	}

	/**
	 * Form Display Actions.
	 *
	 * @param bool  $load_form Form should be loaded or not.
	 * @param array $form_data Form Data.
	 */
	public function display_form( $load_form, $form_data ) {
		if ( empty( $form_data['settings']['form_restriction']['max_number_entries'] ) || ! isset( $form_data['settings']['form_restriction']['max_entry_number'] ) || 0 >= $form_data['settings']['form_restriction']['max_entry_number'] ) {
			return $load_form;
		}

		$max_entry_count = ! empty( $form_data['settings']['form_restriction']['max_entry_number'] ) ? (int) $form_data['settings']['form_restriction']['max_entry_number'] : 0;
		$period          = ! empty( $form_data['settings']['form_restriction']['entry_period'] ) ? $form_data['settings']['form_restriction']['entry_period'] : 'total_entries';

		global $wpdb;

		$col     = 'date_created';
		$query[] = "SELECT entry_id FROM {$wpdb->prefix}evf_entries";
		$query[] = $wpdb->prepare( 'WHERE form_id=%s', absint( $form_data['id'] ) );
		if ( 'day' === $period ) {
			$year    = "YEAR(`{$col}`) = YEAR(NOW())";
			$month   = "MONTH(`{$col}`) = MONTH(NOW())";
			$day     = "DAY(`{$col}`) = DAY(NOW())";
			$query[] = $wpdb->prepare( '%s', "AND {$year} AND {$month} AND {$day}" );
		} elseif ( 'week' === $period ) {
			$query[] = $wpdb->prepare( '%s', "AND YEARWEEK(`{$col}`, 1) = YEARWEEK(CURDATE(), 1)" );
		} elseif ( 'month' === $period ) {
			$year    = "YEAR(`{$col}`) = YEAR(NOW())";
			$month   = "MONTH(`{$col}`) = MONTH(NOW())";
			$query[] = $wpdb->prepare( '%s', "AND {$year} AND {$month}" );
		} elseif ( 'year' === $period ) {
			$query[] = $wpdb->prepare( '%s', "AND YEAR(`{$col}`) = YEAR(NOW())" );
		}
		$entries_count = count( $wpdb->get_results( implode( ' ', $query ), ARRAY_A ) );

		if ( $entries_count < $max_entry_count ) {
			return $load_form;
		}

		add_action( 'everest_forms_frontend_not_loaded', array( $this, 'show_entry_exceed_message' ), 10, 1 );
	}

	/**
	 * Form submit actions.
	 *
	 * @param array $errors Form submit errors.
	 * @param array $form_data Form Data.
	 */
	public function submit_form( $errors, $form_data ) {
		$locked = true;
		if ( empty( $form_data['settings']['form_restriction']['max_number_entries'] ) || ! isset( $form_data['settings']['form_restriction']['max_entry_number'] ) || 0 >= $form_data['settings']['form_restriction']['max_entry_number'] ) {
			$locked = false;
		}

		$max_entry_count = ! empty( $form_data['settings']['form_restriction']['max_entry_number'] ) ? (int) $form_data['settings']['form_restriction']['max_entry_number'] : 0;

		$entries_count = count( evf_get_entries_ids( $form_data['id'] ) );

		if ( $entries_count < $max_entry_count ) {
			$locked = false;
		}

		if ( $locked ) {
			$form_id                      = ! empty( $form_data['id'] ) ? $form_data['id'] : 0;
			$errors[ $form_id ]['header'] = __( 'Form has not been submitted, Entries count for this form has been exceed.', 'everest-forms-form-restriction' );
		}
		return $errors;
	}

	/**
	 * Show entry exceed message.
	 *
	 * @param array $form_data Form Data.
	 */
	public function show_entry_exceed_message( $form_data ) {
		$message = ! empty( $form_data['settings']['form_restriction']['max_entry_message'] ) ? $form_data['settings']['form_restriction']['max_entry_message'] : '';
		if ( $message ) {
			printf( '<p class="everest-forms-notice everest-forms-notice--error">%s</p>', wp_kses_post( $message ) );
		}
	}
}
