<?php
/**
 * EverestForms Form Restriction Empty Submission.
 *
 * @package EverestForms_Form_Restriction\Empty_Submission
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( class_exists( 'EVFFR_Empty_Submission', false ) ) {
	return new EVFFR_Empty_Submission();
}

/**
 * EVFFR_Empty_Submission Class.
 */
class EVFFR_Empty_Submission {

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->hooks();
	}

	/**
	 * Locker hooks.
	 *
	 * @since 1.0.0
	 */
	public function hooks() {
		add_filter( 'everest_forms_process_initial_errors', array( $this, 'submit_form' ), 10, 2 );
	}

	/**
	 * Form submit actions.
	 *
	 * @param array $errors Form submit errors.
	 * @param array $form_data Form Data.
	 */
	public function submit_form( $errors, $form_data ) {
		$locked = true;
		if ( empty( $form_data['settings']['form_restriction']['empty_submission'] ) ) {
			$locked = false;
		}

		$entry = isset( $_POST['everest_forms']['form_fields'] ) ? $_POST['everest_forms']['form_fields'] : array();

		if ( ! array_filter( $entry ) && $locked ) {
			$form_id                      = ! empty( $form_data['id'] ) ? $form_data['id'] : 0;
			$message                      = ! empty( $form_data['settings']['form_restriction']['empty_submission_message'] ) ? $form_data['settings']['form_restriction']['empty_submission_message'] : '';
			$errors[ $form_id ]['header'] = $message;
		}
		return $errors;
	}
}
